/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.part;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.constants.EnumParts;

public class LayerModel {
    private ResourceLocation obj;
    private ItemStack stack = ItemStack.field_190927_a;
    public int slotID = 0;
    public EnumParts part = EnumParts.HEAD;
    public final float[] offset = new float[]{0.0f, 0.0f, 0.0f};
    public final float[] rotation = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public final float[] scale = new float[]{1.0f, 1.0f, 1.0f};

    public LayerModel() {
    }

    public LayerModel(NBTTagCompound compound) {
        this.load(compound);
    }

    public void load(NBTTagCompound compound) {
        this.obj = null;
        if (compound.func_150297_b("OBJ", 8)) {
            this.obj = new ResourceLocation(compound.func_74779_i("OBJ"));
        }
        this.slotID = compound.func_74762_e("SlotID");
        this.part = EnumParts.getMainModel(compound.func_74762_e("PartID"));
        for (int i = 0; i < 3; ++i) {
            this.offset[i] = compound.func_150295_c("Offset", 5).func_150308_e(i);
            this.rotation[i] = compound.func_150295_c("Rotation", 5).func_150308_e(i);
            this.scale[i] = compound.func_150295_c("Scale", 5).func_150308_e(i);
            if (!(this.scale[i] < 0.0f)) continue;
            int n = i;
            this.scale[n] = this.scale[n] * -1.0f;
        }
        this.stack = ItemStack.field_190927_a;
        if (compound.func_150297_b("Item", 10)) {
            this.stack = new ItemStack(compound.func_74775_l("Item"));
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.obj != null) {
            compound.func_74778_a("OBJ", this.obj.toString());
        }
        compound.func_74768_a("SlotID", this.slotID);
        compound.func_74768_a("PartID", this.part.ordinal());
        NBTTagList listRot = new NBTTagList();
        NBTTagList listOff = new NBTTagList();
        NBTTagList listSc = new NBTTagList();
        for (int i = 0; i < 3; ++i) {
            listRot.func_74742_a((NBTBase)new NBTTagFloat(this.rotation[i]));
            listOff.func_74742_a((NBTBase)new NBTTagFloat(this.offset[i]));
            listSc.func_74742_a((NBTBase)new NBTTagFloat(this.scale[i]));
        }
        compound.func_74782_a("Rotation", (NBTBase)listRot);
        compound.func_74782_a("Offset", (NBTBase)listOff);
        compound.func_74782_a("Scale", (NBTBase)listSc);
        compound.func_74782_a("Item", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        return compound;
    }

    public ResourceLocation getOBJ() {
        return this.obj;
    }

    public void setOBJ(String newOBJ) {
        this.obj = newOBJ == null || newOBJ.isEmpty() ? null : new ResourceLocation(newOBJ.replaceAll("\\\\", "/"));
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack newStack) {
        if (newStack == null) {
            newStack = ItemStack.field_190927_a;
        }
        this.stack = newStack;
    }
}

